# Copyright 2020 Autodesk, Inc.  All rights reserved.
#
# Use of this software is subject to the terms of the Autodesk license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.

from ctypes import *
from .arnold_common import ai, NullToNone
from .ai_node_entry import *
from .ai_types import *

class AtMetadataStore(Structure):
   pass

AiMetaDataGetBool = ai.AiMetaDataGetBool
AiMetaDataGetBool.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(c_bool)]
AiMetaDataGetBool.restype = c_bool

AiMetaDataGetInt = ai.AiMetaDataGetInt
AiMetaDataGetInt.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(c_int)]
AiMetaDataGetInt.restype = c_bool

AiMetaDataGetFlt = ai.AiMetaDataGetFlt
AiMetaDataGetFlt.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(c_float)]
AiMetaDataGetFlt.restype = c_bool

AiMetaDataGetVec = ai.AiMetaDataGetVec
AiMetaDataGetVec.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(AtVector)]
AiMetaDataGetVec.restype = c_bool

AiMetaDataGetVec2 = ai.AiMetaDataGetVec2
AiMetaDataGetVec2.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(AtVector2)]
AiMetaDataGetVec2.restype = c_bool

AiMetaDataGetRGB = ai.AiMetaDataGetRGB
AiMetaDataGetRGB.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(AtRGB)]
AiMetaDataGetRGB.restype = c_bool

AiMetaDataGetStr = ai.AiMetaDataGetStr
AiMetaDataGetStr.argtypes = [POINTER(AtNodeEntry), AtString, AtString, POINTER(AtStringStruct)]
AiMetaDataGetStr.restype = c_bool

AiMetaDataLoadFile = ai.AiMetaDataLoadFile
AiMetaDataLoadFile.argtypes = [AtPythonString]
AiMetaDataLoadFile.restype = c_bool

_AiMetadataStore = ai.AiMetadataStore
_AiMetadataStore.restype = c_void_p

def AiMetadataStore():
   return NullToNone(_AiMetadataStore(), POINTER(AtMetadataStore))

AiMetadataStoreDestroy = ai.AiMetadataStoreDestroy
AiMetadataStoreDestroy.argtypes = [POINTER(AtMetadataStore)]

AiMetadataStoreLoadFromASS = ai.AiMetadataStoreLoadFromASS
AiMetadataStoreLoadFromASS.argtypes = [POINTER(AtMetadataStore), AtString]
AiMetadataStoreLoadFromASS.restype = c_bool

_AiMetadataStoreGetIterator = ai.AiMetadataStoreGetIterator
_AiMetadataStoreGetIterator.argtypes = [POINTER(AtMetadataStore)]
_AiMetadataStoreGetIterator.restype = c_void_p

def AiMetadataStoreGetIterator(mds):
   return NullToNone(_AiMetadataStoreGetIterator(mds), POINTER(AtMetaDataIterator))

AiMetadataStoreSetBool = ai.AiMetadataStoreSetBool
AiMetadataStoreSetBool.argtypes = [POINTER(AtMetadataStore), AtString, c_bool]

AiMetadataStoreSetInt = ai.AiMetadataStoreSetInt
AiMetadataStoreSetInt.argtypes = [POINTER(AtMetadataStore), AtString, c_int]

AiMetadataStoreSetFlt = ai.AiMetadataStoreSetFlt
AiMetadataStoreSetFlt.argtypes = [POINTER(AtMetadataStore), AtString, c_float]

AiMetadataStoreSetVec = ai.AiMetadataStoreSetVec
AiMetadataStoreSetVec.argtypes = [POINTER(AtMetadataStore), AtString, AtVector]

AiMetadataStoreSetVec2 = ai.AiMetadataStoreSetVec2
AiMetadataStoreSetVec2.argtypes = [POINTER(AtMetadataStore), AtString, AtVector2]

AiMetadataStoreSetRGB = ai.AiMetadataStoreSetRGB
AiMetadataStoreSetRGB.argtypes = [POINTER(AtMetadataStore), AtString, AtRGB]

AiMetadataStoreSetStr = ai.AiMetadataStoreSetStr
AiMetadataStoreSetStr.argtypes = [POINTER(AtMetadataStore), AtString, AtString]

AiMetadataStoreGetBool = ai.AiMetadataStoreGetBool
AiMetadataStoreGetBool.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(c_bool)]
AiMetadataStoreGetBool.restype = c_bool

AiMetadataStoreGetInt = ai.AiMetadataStoreGetInt
AiMetadataStoreGetInt.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(c_int)]
AiMetadataStoreGetInt.restype = c_bool

AiMetadataStoreGetFlt = ai.AiMetadataStoreGetFlt
AiMetadataStoreGetFlt.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(c_float)]
AiMetadataStoreGetFlt.restype = c_bool

AiMetadataStoreGetVec = ai.AiMetadataStoreGetVec
AiMetadataStoreGetVec.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(AtVector)]
AiMetadataStoreGetVec.restype = c_bool

AiMetadataStoreGetVec2 = ai.AiMetadataStoreGetVec2
AiMetadataStoreGetVec2.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(AtVector2)]
AiMetadataStoreGetVec2.restype = c_bool

AiMetadataStoreGetRGB = ai.AiMetadataStoreGetRGB
AiMetadataStoreGetRGB.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(AtRGB)]
AiMetadataStoreGetRGB.restype = c_bool

AiMetadataStoreGetStr = ai.AiMetadataStoreGetStr
AiMetadataStoreGetStr.argtypes = [POINTER(AtMetadataStore), AtString, POINTER(AtStringStruct)]
AiMetadataStoreGetStr.restype = c_bool
